library(survival)
library(survminer)
library(ggplot2)
head(data)
#   event time    value group
# 1     0    0 4.267446  High
# 2     0 1523 2.803868   Low
# 3     1  121 5.427261  High
# 4     0  607 3.705115  High
# 5     0  426 2.094844   Low
# 6     0 1369 3.944624  High
fit <- survfit(Surv(time, event) ~ group, data = data)
print(fit)
# Call: survfit(formula = survival::Surv(time, event) ~ group, data = dat)
# 
#              n events median 0.95LCL 0.95UCL
# group=Low  267     73   1798    1622      NA
# group=High 263    115   1171     995    1492
# coxph
fit_cox <- coxph(Surv(time, event) ~ group, data = data)
print(fit_cox)
# Call:
# survival::coxph(formula = survival::Surv(time, event) ~ group, 
#     data = dat)
# 
#   n= 530, number of events= 188 
# 
#             coef exp(coef) se(coef)     z Pr(>|z|)    
# groupHigh 0.6468    1.9093   0.1500 4.312 1.62e-05 ***
# ---
# Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
# 
#           exp(coef) exp(-coef) lower .95 upper .95
# groupHigh     1.909     0.5237     1.423     2.562
# 
# Concordance= 0.591  (se = 0.02 )
# Likelihood ratio test= 19.19  on 1 df,   p=1e-05
# Wald test            = 18.6  on 1 df,   p=2e-05
# Score (logrank) test = 19.24  on 1 df,   p=1e-05
# 
cox.zph(fit_cox)
#        chisq df    p
# group    1.7  1 0.19
# GLOBAL   1.7  1 0.19
## plot
ggsurvplot(fit = fit, data = data, fun = "pct",
           palette = c("#4DBBD5", "#E64B35", "#BEBADA", "#FFFFB3", "#8DD3C7"),
           linetype = 1, pval = TRUE, 
           censor = TRUE, censor.size = 7,
           risk.table = FALSE, conf.int = FALSE)
